using System;

namespace Implab {
    abstract class PromiseReaction<T> : IResolvable<T> {
        readonly IDispatcher m_dispatcher;

        protected PromiseReaction(IDispatcher dispatcher) {
            m_dispatcher = dispatcher;
        }

        protected abstract bool HasFulfilHandler {
            get;
        }

        protected abstract bool HasRejectHandler {
            get;
        }

        public void Reject(Exception error) {
            if (!HasRejectHandler)
                DefaultReject(error);
            else if (m_dispatcher != null)
                m_dispatcher.Enqueue(() => RejectImpl(error));
            else
                RejectImpl(error);
        }

        public void Resolve(T result) {
            if (!HasFulfilHandler)
                DefaultResolve(result);
            else if (m_dispatcher != null)
                m_dispatcher.Enqueue(() => ResolveImpl(result));
            else
                ResolveImpl(result);
        }

        protected abstract void ResolveImpl(T result);

        protected abstract void RejectImpl(Exception reason);

        protected abstract void DefaultResolve(T result);

        protected abstract void DefaultReject(Exception reason);
    }
}